/*
 * InformationTableModel.cpp
 *
 *  Created on: 28.10.2009
 *      Author: stefan.detter
 */

#include "InformationTableModel.h"

InformationTableModel::InformationTableModel(QObject* parent)
	: QAbstractTableModel(parent)
{
	m_infoItem = 0;

	connect(this, SIGNAL(aboutToReset()), this, SIGNAL(modelAboutToBeReset()));
	connect(this, SIGNAL(reset()), this, SIGNAL(modelReset()));
}

InformationTableModel::~InformationTableModel()
{
}


int InformationTableModel::rowCount(const QModelIndex &/*parent*/) const
{
	if(m_infoItem == 0)
		return 0;
	
	return m_infoItem->informationRowCount();
}

int InformationTableModel::columnCount(const QModelIndex &/*parent*/) const
{
	return 2;
}

QVariant InformationTableModel::data(const QModelIndex &index, int role) const
{
	return m_infoItem->information(index.row(), index.column(), role);
}

QVariant InformationTableModel::headerData(int section, Qt::Orientation orientation, int role) const
{
	if (role != Qt::DisplayRole)
		return QVariant();

	if(orientation == Qt::Horizontal){
		switch(section)
		{
		case 0:
			return "Property";
		case 1:
			return "Value";
		}
	}
	else
		return QString::number(section + 1);

	return "NULL";

}


void InformationTableModel::setInformationItem(const TreeItem* t)
{
	if(m_infoItem != 0)
		disconnect(m_infoItem, SIGNAL(informationChanged(int, int)), this, SLOT(itemInformationChanged(int, int)));
	emit aboutToReset();
	m_infoItem = 0;
	emit reset();

	emit beginInsertRows(QModelIndex(), 0, t->informationRowCount()-1 );
	m_infoItem = t;
	emit endInsertRows();
	connect(m_infoItem, SIGNAL(informationChanged(int, int)), this, SLOT(itemInformationChanged(int, int)));
	connect(m_infoItem, SIGNAL(informationBeginInsertRow(int)), this, SLOT(itemInformationBeginInsertRow(int)));
	connect(m_infoItem, SIGNAL(informationEndInsertRow()), this, SLOT(itemInformationEndInsertRow()));
}

void InformationTableModel::itemInformationChanged(int first, int last)
{
	int count = rowCount(QModelIndex());

	if(first >= count || last >= count)
		return;

	QModelIndex topLeft = this->index( first, 1 );
	QModelIndex bottomRight = this->index( last, 1 );
	emit dataChanged(topLeft, bottomRight);
}

void InformationTableModel::itemInformationBeginInsertRow(int index)
{
	emit beginInsertRows(QModelIndex(), index, index );
}

void InformationTableModel::itemInformationEndInsertRow()
{
	emit endInsertRows();
}


